<?php
    include 'db_connect.php';
    $date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
?>
<div class="container-fluid">
    <div class="col-lg-12">
        <div class="card">
            <div class="card_body">
                <div class="row justify-content-center pt-4">
                    <label for="" class="mt-2">Date</label>
                    <div class="col-sm-3">
                        <input type="date" name="date" id="date" value="<?php echo $date ?>" class="form-control">
                    </div>
                </div>
                <hr>
                <div class="col-md-12">
                    <table class="table table-bordered" id='report-list'>
                        <thead>
                            <tr>
                                <th class="text-center">#</th>
                                <th>Date</th>
                                <th>Invoice</th>
                                <th>Order Number</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $i = 1;
                                $total = 0;
                                $sales = $conn->query("SELECT * FROM orders WHERE amount_tendered > 0 AND DATE(date_created) = '$date' ORDER BY unix_timestamp(date_created) ASC");
                                if($sales->num_rows > 0):
                                    while($row = $sales->fetch_array()):
                                        $total += $row['total_amount'];
                            ?>
                            <tr>
                                <td class="text-center"><?php echo $i++ ?></td>
                                <td><b><?php echo date("M d, Y", strtotime($row['date_created'])) ?></b></td>
                                <td><b><?php echo $row['amount_tendered'] > 0 ? $row['ref_no'] : 'N/A' ?></b></td>
                                <td><b><?php echo $row['order_number'] ?></b></td>
                                <td class="text-right"><b><?php echo number_format($row['total_amount'], 2) ?></b></td>
                            </tr>
                            <?php
                                    endwhile;
                                else:
                            ?>
                            <tr>
                                <th class="text-center" colspan="5">No Data.</th>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="4" class="text-right">Total</th>
                                <th class="text-right"><?php echo number_format($total, 2) ?></th>
                            </tr>
                        </tfoot>
                    </table>
                    <hr>
                    <div class="col-md-12 mb-4">
                        <center>
                            <button class="btn btn-success btn-sm col-sm-3" type="button" id="print">
                                <i class="fa fa-print"></i> Print
                            </button>
                        </center>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<noscript>
    <style>
        table#report-list {
            width: 100%;
            border-collapse: collapse;
        }
        table#report-list td, table#report-list th {
            border: 1px solid;
        }
        p {
            margin: unset;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
    </style>
</noscript>

<script>
    $('#date').change(function() {
        location.replace('index.php?page=sales_report&date=' + $(this).val())
    })

    $('#print').click(function() {
        var _c = $('#report-list').clone();
        var ns = $('noscript').clone();
        ns.append(_c)
        var nw = window.open('', '_blank', 'width=900,height=600')
        nw.document.write('<p class="text-center"><b>Order Report for <?php echo date("F d, Y", strtotime($date)) ?></b></p>')
        nw.document.write(ns.html())
        nw.document.close()
        nw.print()
        setTimeout(() => {
            nw.close()
        }, 500);
    })
</script>